%%%% STAGE 2a, FitParameters %%%%
%%%% Fits data with selected models, requires input from Stage 1

clearvars -except filename filenamevec SAR_model SAR_MODEL nSAR; close all; clc; 

load(['./ComputeData/' filename '.mat']);   %loads data file from Stage1
nt = length(records);                       %number of signals (e.g. IRSL50, IRSL100 etc.)

na = nSAR; 

modvec = logspace(0,6,100);                 
tvec = logspace(0,6,100);                   
natdose = linspace(0,10000,10000);          

%Define constants
Ma = 1e6*365*24*3600;                       
ka = Ma./1000;                              


for i=1:nt  %loop through the number of traps

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%% Dose Response Curve %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %extract data from mat file
	labDdot = records(i).rawdata(1).Ddot;           % laboratory dose rate 
    
    for jj=1:na
	t = [records(i).rawdata(jj:jj).t];              % measurement times
	L = [records(i).rawdata(jj:jj).L];              % luminescence data
    L_err = [records(i).rawdata(jj:jj).Lerror];     % Luminescence error
	ok = isfinite(t); x = t(ok); y = L(ok);         % remove NaN values%%

    if SAR_model==1 %Selects SSE fit   
        beta0 = [1 1000]';                          %initial parameters, scaling parameter, D0 estimation
        [beta,R,J,Cov,MSE] = nlinfit(x,y,@SarfitGK,beta0);
    
        %confidence interval
        [Ypred,delta] = nlpredci(@SarfitGK,modvec,beta,R,'covar',Cov,'alpha',.05,'predopt','curve');
        sbeta = nlparci(beta,R,'covar',Cov,'alpha',1-.68);
        sigma = abs(beta-sbeta(:,2));               %calculate parameter uncertainties

    end
    
    if SAR_model==2   % DSE
        %ndoubleexpfit solution
        beta0 = [1 10 10 1000]';                    %initial parameters, scaling parameter, D0 estimation
        [beta,R,J,Cov,MSE] = nlinfit(x,y,@DSE,beta0);
    
        %confidence interval
        [Ypred,delta] = nlpredci(@DSE,modvec,beta,R,'covar',Cov,'alpha',.05,'predopt','curve');
        sbeta = nlparci(beta,R,'covar',Cov,'alpha',1-.68);
        sigma = abs(beta-sbeta(:,2));               %calculate parameter uncertainties
    end

        %extract D0
        D0(i,jj) = beta(2).*labDdot; sD0(i,jj) = sigma(2).*labDdot;  %D0
        
        if SAR_model==2
        D02(i,jj) = beta(4).*labDdot; sD02(i,jj) = sigma(4).*labDdot;  %D0
        end

    Ln = L(~ok); sLn=L_err(~ok); rmNA = isfinite(Ln); Ln=Ln(rmNA); sLn=sLn(rmNA); AvLn = mean(Ln); 

    [Ypred,index] = unique(Ypred);
    De(i,jj) = (interp1(Ypred,modvec(index).*labDdot,AvLn, 'linear'))
        
    if SAR_model==1
    De_err(i,jj) = De(1)*sqrt(((sLn/AvLn)^2)+(((labDdot/100)/labDdot)^2)+((sD0(i,jj)/D0(i,jj))^2));
    end

    if SAR_model==2
    De_err(i,jj) = De(1)*sqrt(((sLn/AvLn)^2)+(((labDdot/100)/labDdot)^2)+((sD0(i,jj)/D0(i,jj))^2)+((sD02(i,jj)/D02(i,jj))^2));
    
    end

figure(i) %Given dose is expressed in seconds
semilogx(x,y,'o','LineWidth', 2); hold on; 
semilogx(modvec(index),Ypred,'LineWidth', 2);
scatter(1,Ln,'yp','filled','MarkerEdgeColor','k')
    
hold on;

figure(i+1) %Given dose is expressed in Gray
title(filename)
semilogx(x*labDdot,y,'o','LineWidth', 2); hold on; %ylim([0 2*max(y)])
semilogx(modvec(index)*labDdot,Ypred,'LineWidth', 2);
set(gca,'FontSize',20, 'FontName', 'Arial');
ylim([0 3.5])
xlim([0 260])

scatter(0.1,Ln,60,'yp','filled','MarkerEdgeColor','k','LineWidth',1.5)
xlabel ('Dose (Gy)');
ylabel ('Lx/Tx')


hold on

figure(i + 2) %Given dose is expressed in Gray
title(filename)
plot(x * labDdot, y, 'o','LineWidth', 2); hold on; % 
plot(modvec(index) * labDdot, Ypred,'LineWidth', 2);
set(gca,'FontSize',20, 'FontName', 'Arial');
ylim([0 3.5])
xlim([0 260])

scatter(0.1,Ln,60,'yp','filled','MarkerEdgeColor','k','LineWidth',1.5)
xlabel('Dose (Gy)');
ylabel('Lx/Tx');
    end
end

save(['./ComputeData/' filename '_' SAR_MODEL '_fitpar.mat'],'records')

